# How to contribute

## Getting Started

* Make sure you have a [GitHub account](https://github.com/signup/free)
* Submit a ticket for your issue, assuming one does not already exist.
  * Clearly describe the issue including steps to reproduce when it is a bug.
  * Make sure you fill in the earliest version that you know has the issue.

## Making Changes

* Fork the repository on GitHub.
* Make the changes to your forked repository.
  * **Ensure you stick to the [WordPress Coding Standards](http://make.wordpress.org/core/handbook/coding-standards/php/).**
  * Ensure you use LF line endings - no crazy windows line endings. :)
* When committing, reference your issue (#1234) and include a note about the fix.
* Push the changes to your fork and submit a pull request on the master branch of the Unyson repository. Existing maintenance branches will be maintained of by Unyson developers.

At this point you're waiting on us to merge your pull request. We'll review all pull requests, and make suggestions and changes if necessary.

# Additional Resources

* [General GitHub documentation](http://help.github.com/)
* [GitHub pull request documentation](http://help.github.com/send-pull-requests/)
* [Unyson Docs](http://manual.unyson.io/)
